
<?php

// Set your API credentials and other parameters
$customer_id = $_REQUEST['customer_id'];

echo $apiUrl = 'https://googleads.googleapis.com/v14/customers/'.$customer_id.'/campaigns'; // Replace {customer_id} with your customer ID
$accessToken = $_REQUEST['access_token']; // Replace with your OAuth2 access token

// Initialize cURL session
$ch = curl_init($apiUrl);

// Set cURL options
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . $accessToken,
    'Content-Type: application/json',
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

// Execute the cURL request
$response = curl_exec($ch);

// Check for errors
if ($response === false) {
    echo 'cURL Error: ' . curl_error($ch);
    exit;
}

// Get HTTP status code
$httpStatus = curl_getinfo($ch, CURLINFO_HTTP_CODE);

// Close cURL session
curl_close($ch);

// Check if the request was successful
if ($httpStatus === 200) {
    $data = json_decode($response, true);

    // Access the list of campaigns
    $campaigns = $data['campaigns'];

    // Process the campaigns as needed
    foreach ($campaigns as $campaign) {
        echo 'Campaign ID: ' . $campaign['campaignId'] . '<br>';
        echo 'Name: ' . $campaign['name'] . '<br>';
        // Output other campaign details as needed
        echo '<br>';
    }
} else {
    echo 'Error: HTTP ' . $httpStatus;
}