<?php

require 'vendor/autoload.php'; // Include the Composer autoload file

// Set your OAuth 2.0 client ID and secret
$client_id = '66754600165-r28h5jkvqv7qihdo5d2tsaf7v00a5ju1.apps.googleusercontent.com';
$client_secret = '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';

// Create a new Google_Client instance
$client = new Google_Client();
$client->setApplicationName('Google Ads API PHP Example');
$client->setClientId($client_id);
$client->setClientSecret($client_secret);

// Set the scope to access the Google Ads API
$client->addScope(Google_Service_Ads_GoogleAds::ADS);

// Create a new Google_Service_Ads_GoogleAds instance
$googleAdsService = new Google_Service_Ads_GoogleAds($client);

// Authenticate with OAuth 2.0
if (!file_exists('token.json')) {
    // If the token file doesn't exist, initiate the OAuth flow
    $authUrl = $client->createAuthUrl();
    echo "Open the following URL in your browser to authorize the application:\n";
    echo $authUrl . "\n";
    echo "Enter verification code: ";
    $authCode = trim(fgets(STDIN));

    // Exchange the authorization code for an access token
    $accessToken = $client->fetchAccessTokenWithAuthCode($authCode);

    // Save the access token to a file for future use
    file_put_contents('token.json', json_encode($accessToken));
} else {
    // If the token file exists, use the stored access token
    $accessToken = json_decode(file_get_contents('token.json'), true);
    $client->setAccessToken($accessToken);
}

// Check if the access token has expired, and refresh it if necessary
if ($client->isAccessTokenExpired()) {
    $client->fetchAccessTokenWithRefreshToken($client->getRefreshToken());
    file_put_contents('token.json', json_encode($client->getAccessToken()));
}

// List Google Ads accounts
try {
    $customerIds = $googleAdsService->customers->listCustomers();
    foreach ($customerIds as $customer) {
        echo "Customer ID: " . $customer->resourceName . "\n";
    }
} catch (Google_Service_Exception $e) {
    echo "Error listing Google Ads accounts: " . $e->getMessage() . "\n";
}

?>
Make sure to replace 'YOUR_CLIENT_ID' and 'YOUR_CLIENT_SEC